/**
 * MachForm
 * 
 * © 2007–2025 Appnitro Software. All rights reserved.
 * 
 * This source code is proprietary and may not be copied, modified,
 * or distributed in any form without express written permission from Appnitro Software.
 * 
 * License information: https://www.machform.com/license-agreement/
 */
$(function(){
    
	//we're using tippy for the tooltip
	tippy('[data-tippy-content]',{
		trigger: 'click',
		placement: 'bottom',
		boundary: 'window',
		arrow: true
	});

	//'save integration' button being clicked
	$("#button_save_integration").on('click',function(){
		
		//display loader while saving
		if($("#button_save_integration").text() == 'Saving...'){
			return false;
		}

		$("#button_save_integration").text('Saving...');
		$("#button_save_integration").after("<div class='small_loader_box' style='float: left;margin-top: -8px'><img src='images/loader_small_grey.gif' /></div>");
		$("#button_remove_integration").hide();

		var form_id = $(".integrations_settings").data("formid");
		var csrf_token = $(".integrations_settings").data("csrftoken");
		var selected_columns = $("#gsheets_field_selection_list input.checkbox:checked").serializeArray();

		var gsheet_delay_notification_until_paid = 0;
		if($("#gsheet_delay_notification_until_paid").prop("checked") == true){
			gsheet_delay_notification_until_paid = 1;
		}

		var gsheet_delay_notification_until_approved = 0;
		if($("#gsheet_delay_notification_until_approved").prop("checked") == true){
			gsheet_delay_notification_until_approved = 1;
		}
		
		//send to backend using ajax call
		axios.post('save_integration_gsheets.php', {
			form_id: form_id,
			csrf_token: csrf_token,
			gsheet_delay_notification_until_paid: gsheet_delay_notification_until_paid,
			gsheet_delay_notification_until_approved: gsheet_delay_notification_until_approved,
		 	col_pref: selected_columns
		})
		.then(function (response) {
			if(response.data.status == 'ok'){
				window.location.replace('integration_settings.php?id=' + response.data.form_id);
			}else{
				Swal.fire({
					width: '30%',
					position: 'center',
					icon: 'error',
					title: 'Error. Unable to complete the task.',
					html: response.data,
					showConfirmButton: false,
					showCancelButton: true,
					cancelButtonText: 'Close',
					allowOutsideClick: true
				});
			}
		})
		.catch(function (error) {
			Swal.fire({
				width: '30%',
				position: 'center',
				icon: 'error',
				title: 'Error. Unable to complete the task.',
				html: error,
				showConfirmButton: false,
				showCancelButton: true,
				cancelButtonText: 'Close',
				allowOutsideClick: true
			});
		});

		return false;
	});

	//open the dialog when the 'remove integration' link clicked
	$("#button_remove_integration").on('click',function(){
		var form_id = $(".integrations_settings").data("formid");
		var csrf_token = $(".integrations_settings").data("csrftoken");

		Swal.fire({
			title: 'Are you sure you want to remove the integration?',
			html: `This will unlink Google Sheets from your form.<br/>Your spreadsheet will remain intact but won't receive any new entries.`,
			icon: 'warning',
			width: '40%',
			customClass: {
				htmlContainer: 'swal2-html-container-bold swal2-html-container-padding-bottom',
				title: 'swal2-title-warning'
			},
			showCancelButton: true,
			confirmButtonText: 'Yes. Remove integration',
			showLoaderOnConfirm: true,
			preConfirm: () => {
				return axios.post('delete_integration_gsheets.php', {
					form_id: form_id,
					csrf_token: csrf_token
				})
				.then(function (response) {
					if(response.data.status == 'ok'){
						return response;
					}else{
						Swal.showValidationMessage('Error: Unable to process. Please try again later.');
					}
				})
				.catch(function (error) {
					Swal.showValidationMessage("Error: " + error);
				})
			},
			allowOutsideClick: () => !Swal.isLoading()
		}).then((result) => {
			if(result.isConfirmed) {
				//redirect to entries page again
				window.location.replace('integration_settings.php?id=' + result.value.data.form_id);
			}
		});
		
		return false;
	});
});